ORCA/M Asm65816 2.1.0

0001 FE53              **********************************************************************
0002 FE53              *
0003 FE53              * Converter.asm
0004 FE53              *
0005 FE53              * Copyright 1988-1989
0006 FE53              * Apple Computer, Inc.
0007 FE53              * All Rights Reserved
0008 FE53              *
0009 FE53              * Orig Author
0010 FE53              *
0011 FE53              * Steven Glass
0012 FE53              *
0013 FE53              **********************************************************************
0014 FE53                       blanks off 
0015 FE53                       include 'all.macros' 
0016 FE53
0017 FE53
0018 FE53
0019 FE53
0020 FE53
0021 FE53              ****************************************************************
0022 FE53              *
0023 FE53              GetCodeResConverter PROC EXPORT  
0024 FE53              *
0025 FE53              * Returns the address of the code resource converter routine.
0026 FE53              * It can be used by any one independent of the control manager.
0027 FE53              *
0028 FE53              *
0029 FE53              * Inputs:
0030 FE53              *                   none
0031 FE53              *
0032 FE53              * Outputs:
0033 FE53              *                   none
0034 FE53              *
0035 FE53              * External Refs:
0036 FE53              *                   none
0037 FE53              *
0038 FE53              * Entry Points:
0039 FE53              *                   none
0040 FE53              *
0041 FE53                       longa on                       ; mode
0042 FE53                       longi on
0043 FE53              *
0044 FE53              ****************************************************************
0045 FE53
0046 FE53
0047 FE53              Result   equ   7
0048 FE53
0049 FE53 A9 62 FE              lda   #CodeResourceConverter
0050 FE56 83 07                 sta   Result,s
0051 FE58 A9 FC 00              lda   #^CodeResourceConverter
0052 FE5B 83 09                 sta   Result+2,s
0053 FE5D A9 00 00              lda   #0
0054 FE60 18                    clc   
0055 FE61 6B                    rtl   
0056 FE62
0057 FE62
0058 FE62                       ENDP 
0059 FE62
0060 FE62
0061 FE62              ****************************************************************
0062 FE62              *
0063 FE62              CodeResourceConverter PROC  
0064 FE62              *
0065 FE62              * This is the routine called by the resource manager when
0066 FE62              * a DefProc resource is loaded or saved to disk.
0067 FE62              *
0068 FE62              *
0069 FE62              * Inputs:
0070 FE62              *       LONG   :    space for result
0071 FE62              *       WORD   :    convert command
0072 FE62              *       LONG   :    convert param
0073 FE62              *       LONG   :    res Pointer
0074 FE62              *
0075 FE62              * Outputs:
0076 FE62              *       LONG   :    result
0077 FE62              *
0078 FE62              * External Refs:
0079 FE62              *                   none
0080 FE62              *
0081 FE62              * Entry Points:
0082 FE62              *                   none
0083 FE62              *
0084 FE62                       longa on                       ; mode
0085 FE62                       longi on
0086 FE62              *
0087 FE62              ****************************************************************
0088 FE62
0089 FE62                       DefineStack 
0090 FE62              OrigD          word      1  
0091 FE62              RTL1           block 3   3  
0092 FE62              ResPointer     long      6  
0093 FE62              ConvertParam   long      A  
0094 FE62              ConvertCmd     word      E  
0095 FE62              Result         long      10  
0096 FE62
0097 FE62
0098 FE62 0B                    phd   
0099 FE63 3B                    tsc   
0100 FE64 5B                    tcd   
0101 FE65
0102 FE65
0103 FE65 64 10                 stz   Result
0104 FE67 64 12                 stz   Result+2
0105 FE69
0106 FE69 A6 0E                 ldx   ConvertCmd
0107 FE6B FC 80 FE              jsr   (ConvertCmdTable,x)
0108 FE6E
0109 FE6E
0110 FE6E
0111 FE6E A6 03                 ldx   RTL1                     ; move the rtl adrs up 10 bytes
0112 FE70 86 0D                 stx   RTL1+10
0113 FE72 A6 04                 ldx   RTL1+1
0114 FE74 86 0E                 stx   RTL1+1+10
0115 FE76
0116 FE76 2B                    pld                            ; restore d
0117 FE77 FA                    plx                            ; strip 10 bytes
0118 FE78 FA                    plx   
0119 FE79 FA                    plx   
0120 FE7A FA                    plx   
0121 FE7B FA                    plx   
0122 FE7C C9 01 00              cmp   #1                       ; set carry correctly.
0123 FE7F 6B                    rtl   
0124 FE80
0125 FE80
0126 FE80
0127 FE80 86 FE        ConvertCmdTable DC W:ConvertRead
0128 FE82 08 FF                 DC W:ConvertWrite
0129 FE84 14 FF                 DC W:ConvertDiskSize
0130 FE86
0131 FE86              ;-----------------------------------------------------------
0132 FE86              ;
0133 FE86              ConvertRead  
0134 FE86              ;
0135 FE86              ; Read the resource from disk, relocate it, dispose
0136 FE86              ; of old handle, put new handle into resref record.
0137 FE86              ;
0138 FE86              ;-----------------------------------------------------------
0139 FE86
0140 FE86
0141 FE86              ;
0142 FE86              ; Read the data into memory
0143 FE86              ;
0144 FE86 D4 0C                 pei   ConvertParam+2
0145 FE88 D4 0A                 pei   ConvertParam
0146 FE8A F4 12 20              PushWord #$2012 
0147 FE8D 22 B0 00 E1           jsl   $E100B0
0148 FE91 90 01                 bcc   @continue
0149 FE93
0150 FE93 60                    rts   
0151 FE94
0152 FE94              @continue  
0153 FE94
0154 FE94
0155 FE94              ;
0156 FE94              ; Lets find the userid of the current memory.
0157 FE94              ;
0158 FE94 A0 10 00              ldy   #ResRefRecord.ResHandle
0159 FE97 B7 06                 lda   [ResPointer],y
0160 FE99 85 10                 sta   result
0161 FE9B C8                    iny   
0162 FE9C C8                    iny   
0163 FE9D B7 06                 lda   [ResPointer],y
0164 FE9F 85 12                 sta   result+2
0165 FEA1
0166 FEA1 A0 06 00              ldy   #6
0167 FEA4 B7 10                 lda   [Result],y
0168 FEA6 A8                    tay                            ; put result in y for now.
0169 FEA7
0170 FEA7 64 10                 stz   Result                   ; fix this again.
0171 FEA9 64 12                 stz   Result+2
0172 FEAB              ;
0173 FEAB              ; Relocate it
0174 FEAB              ;
0175 FEAB 48                    pha                            ; space for user id
0176 FEAC 48                    pha                            ; space for starting addr
0177 FEAD 48                    pha   
0178 FEAE 48                    pha                            ; space for d-page/stack
0179 FEAF 48                    pha                            ; size of d-page/stack
0180 FEB0 5A                    phy                            ; push the desired userid
0181 FEB1 A5 0A                 lda   convertParam             ; point to a packett that has pointer followed by 
0182 FEB3 18                    clc                            ; size
0183 FEB4 69 04 00              adc   #4
0184 FEB7 AA                    tax   
0185 FEB8 A5 0C                 lda   convertParam+2
0186 FEBA 69 00 00              adc   #0
0187 FEBD 48                    pha   
0188 FEBE DA                    phx   
0189 FEBF F4 00 00              PushWord #0                    ; don't use special memory
0190 FEC2 F4 04 00              PushWord #4                    ; input type for mem to mem that stays out of loader table
0191 FEC5 A2 11 20 22           _InitialLoad2 
0192 FECC B0 34                 bcs   @LoadError
0193 FECE 68                    pla                            ; ignore user id
0194 FECF 68                    pla                            ; this is pointer to reloced code
0195 FED0 FA                    plx   
0196 FED1
0197 FED1 7A                    ply                            ; ignore size of direct page buffer
0198 FED2 7A                    ply                            ; ignore addr of direct page buffer
0199 FED3
0200 FED3
0201 FED3              ;
0202 FED3              ; Find the handle to the relocated code and leave result on stack.
0203 FED3              ;
0204 FED3 48                    pha                            ; space for handle
0205 FED4 48                    pha   
0206 FED5 DA                    phx                            ; save pointer to relocated code on the stack.
0207 FED6 48                    pha   
0208 FED7 A2 02 1A 22           _FindHandle 
0209 FEDE B0 25                 bcs   @FindError
0210 FEE0
0211 FEE0              ;
0212 FEE0              ; dispose of old handle
0213 FEE0              ;
0214 FEE0 A0 12 00              ldy   #resRefRecord.resHandle+2
0215 FEE3 B7 06                 lda   [ResPointer],y
0216 FEE5 48                    pha   
0217 FEE6 88                    dey   
0218 FEE7 88                    dey   
0219 FEE8 B7 06                 lda   [ResPointer],y
0220 FEEA 48                    pha   
0221 FEEB A2 02 10 22           _DisposeHandle 
0222 FEF2
0223 FEF2
0224 FEF2              ;
0225 FEF2              ; Put new handle into resource map
0226 FEF2              ;
0227 FEF2 A0 10 00              ldy   #resRefRecord.resHandle
0228 FEF5 68                    pla   
0229 FEF6 97 06                 sta   [ResPointer],y
0230 FEF8 C8                    iny   
0231 FEF9 C8                    iny   
0232 FEFA 68                    pla   
0233 FEFB 97 06                 sta   [ResPointer],y
0234 FEFD
0235 FEFD A9 00 00              lda   #0
0236 FF00 18                    clc   
0237 FF01 60                    rts   
0238 FF02
0239 FF02 FA           @LoadError plx   
0240 FF03 FA                    plx   
0241 FF04 FA                    plx   
0242 FF05 FA           @FindError plx   
0243 FF06 FA                    plx   
0244 FF07 60                    rts   
0245 FF08
0246 FF08              ;-----------------------------------------------------------
0247 FF08              ;
0248 FF08              ConvertWrite  
0249 FF08              ;
0250 FF08              ; Writes the resource to disk.
0251 FF08              ;
0252 FF08              ;-----------------------------------------------------------
0253 FF08              ;
0254 FF08              ; Write the data to disk
0255 FF08              ;
0256 FF08 D4 0C                 pei   ConvertParam+2
0257 FF0A D4 0A                 pei   ConvertParam
0258 FF0C F4 13 20              PushWord #$2013 
0259 FF0F 22 B0 00 E1           jsl   $E100B0
0260 FF13
0261 FF13 60                    rts   
0262 FF14
0263 FF14
0264 FF14
0265 FF14
0266 FF14              ;-----------------------------------------------------------
0267 FF14              ;
0268 FF14              ConvertDiskSize  
0269 FF14              ;
0270 FF14              ; Returns the size the resource will take on disk.
0271 FF14              ;
0272 FF14              ;-----------------------------------------------------------
0273 FF14
0274 FF14              ;
0275 FF14              ; Return the size of the handle in the ResRef record.
0276 FF14              ;
0277 FF14 48                    pha   
0278 FF15 48                    pha   
0279 FF16 A0 12 00              ldy   #ResRefRecord.ResHandle+2
0280 FF19 B7 06                 lda   [ResPointer],y
0281 FF1B 48                    pha   
0282 FF1C 88                    dey   
0283 FF1D 88                    dey   
0284 FF1E B7 06                 lda   [ResPointer],y
0285 FF20 48                    pha   
0286 FF21
0287 FF21 A2 02 18 22           _GetHandleSize 
0288 FF28
0289 FF28              ;
0290 FF28              ; return the result
0291 FF28              ;
0292 FF28 FA                    plx   
0293 FF29 86 10                 stx   Result
0294 FF2B FA                    plx   
0295 FF2C 86 12                 stx   Result+2
0296 FF2E
0297 FF2E 60                    rts   
0298 FF2F
0299 FF2F
0300 FF2F
0301 FF2F
0302 FF2F                       ENDP 
0303 FF2F
0304 FF2F
0305 FF2F
0306 FF2F                       END   
